﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Web.UI;
using Wizdom365.BLL.IoC;
using Wizdom365.BLL.Managers;
using Wizdom365.BLL.Objects;

namespace GUI.Web.Base.Bundles
{
    public partial class Templates : Page
    {
        private readonly HtmlTemplateManager _htmlTemplateManager;
        private readonly ILogger _logger;

        public Templates()
            : this(Ioc.Resolve<HtmlTemplateManager>(), Ioc.Resolve<ILogger>())
        {
        }

        public Templates(HtmlTemplateManager htmlTemplateManager, ILogger logger)
        {
            _htmlTemplateManager = htmlTemplateManager;
            _logger = logger;
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            _logger.Info("GetTemplates start");
            var script = _htmlTemplateManager.GetTemplatesFileContent(false);            
            _logger.Info("GetTemplates end");
            Response.ContentType = "application/javascript";
            Response.Write(script);
        }

        private string FormatHtml(string html)
        {
            return html.Replace("\r", "")
                .Replace("\n", "")
                .Replace("\\'", "\\\\'")
                .Replace("'", "\\'")
                .Replace("\t", "")
                .Replace("  ", " ");
        }
    }
}